<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('phone', 'password', 'name', 'email', 'date_of_birth', 'last_donation_date', 'blood_type_id', 'city_id', 'pin_code');

    public function blood_types()
    {
        return $this->belongsTo('App\Model\BloodType');
    }

    public function city()
    {
        return $this->belongsTo('App\Model\City');
    }

    public function contact()
    {
        return $this->hasOne('App\Model\Contact');
    }

}